IF EXISTS( SELECT 1 FROM SYS.VIEWS WHERE NAME = 'V_EST_PENDENTE_ENTRADA' ) DROP VIEW V_EST_PENDENTE_ENTRADA
GO
--SELECT * FROM V_EST_PENDENTE_ENTRADA WHERE CD_EMP =1 AND CD_FILIAL_DEST=2
CREATE VIEW V_EST_PENDENTE_ENTRADA WITH ENCRYPTION AS
SELECT  
	SAI.CD_EMP, 
	SAI.CD_FILIAL AS CD_FILIAL_ORIG, 
	PEND.CD_FILIAL_DEST,
	PRC_FILIAL_ORIG.NM_FANT AS NM_FANT_ORIG,
	PRC_FILIAL_DEST.NM_FANT AS NM_FANT_DEST,
	SAI.NF_NF AS NR_DOC, 		
	SAI.DT_EMI_NF AS DT_EMI_DOC,
	SAI.DT_EMI_NF AS DT_ENTR,
	0 AS TIPO_DOC,
	DS_MOV_OP_USUAL AS DS_TIPO_DOC,
	SAI.CD_NF AS CD_DOC_ORIC,
	SAI.CD_NT_MOV,
	0 AS PARCIAL,
	VLR_NF,
	GLB_MOV_OP.DEST_ORIG,
	SAI.CD_USU,
	U.NM_USU
FROM       
	EST_NF_SAI SAI 
	INNER JOIN EST_NF_SAI_PENDENCIA PEND ON
	SAI.CD_EMP = PEND.CD_EMP AND
	SAI.CD_FILIAL = PEND.CD_FILIAL AND
	SAI.CD_NF = PEND.CD_NF 
	INNER JOIN PRC_FILIAL PRC_FILIAL_ORIG ON
	PEND.CD_EMP = PRC_FILIAL_ORIG.CD_EMP AND
	PEND.CD_FILIAL = PRC_FILIAL_ORIG.CD_FILIAL
	INNER JOIN PRC_FILIAL PRC_FILIAL_DEST ON
	PEND.CD_EMP = PRC_FILIAL_DEST.CD_EMP AND
	PEND.CD_FILIAL_DEST = PRC_FILIAL_DEST.CD_FILIAL 		
	INNER JOIN dbo.GLB_MOV_OP ON 
	SAI.CD_NT_MOV = dbo.GLB_MOV_OP.CD_MOV_OP
	LEFT JOIN dbo.GLB_USU U ON 
	SAI.CD_USU = U.CD_USU  
WHERE   
	SAI.STS_NF = 0 
	AND SAI.PEND_ENTRADA = 0 
	
UNION ALL
SELECT     
	EST_PED_CP.CD_EMP, 
	EST_PED_CP.CD_FORN, 
	EST_PED_CP.CD_FILIAL, 
	PG_FORN.NM_FANT,
	PRC_FILIAL.NM_FANT,
	EST_PED_CP.CD_PED, 
	EST_PED_CP.DT_EMI,
	ISNULL(EST_PED_CP.DT_PREV_ENT_ANT,EST_PED_CP.DT_PREV_ENT) DT_ENTR,
	1 , 
	'PEDIDO DE COMPRA',
	EST_PED_CP.CD_PED AS CD_DOC_ORIC,
	0 AS CD_NT_MOV,
	STS_PED AS PARCIAL,
	EST_PED_CP.VLR_PED,
	GLB_MOV_OP.DEST_ORIG,
	EST_PED_CP.CD_USU,
	U.NM_USU
FROM    
	EST_PED_CP INNER JOIN PG_FORN ON
	EST_PED_CP.CD_EMP = PG_FORN.CD_EMP AND 
	EST_PED_CP.CD_FORN = PG_FORN.CD_FORN
	INNER JOIN EST_PED_CP_PENDENCIA PEND ON
	EST_PED_CP.CD_EMP = PEND.CD_EMP AND
	EST_PED_CP.CD_FILIAL = PEND.CD_FILIAL AND
	EST_PED_CP.CD_PED = PEND.CD_PED		 
	INNER JOIN PRC_FILIAL ON
	EST_PED_CP.CD_EMP = PRC_FILIAL.CD_EMP	AND
	EST_PED_CP.CD_FILIAL = PRC_FILIAL.CD_FILIAL
	INNER JOIN dbo.GLB_MOV_OP ON 
	EST_PED_CP.CD_NT_MOV = dbo.GLB_MOV_OP.CD_MOV_OP
	LEFT JOIN dbo.GLB_USU U ON 
	EST_PED_CP.CD_USU = U.CD_USU  
WHERE   
	EST_PED_CP.STS_PED <> 2
UNION ALL
SELECT     
	EST_PED_CP.CD_EMP, 
	EST_PED_CP.CD_FORN, 
	EST_PED_CP_VINCULADA.CD_FILIAL_VINCULADA, 
	PG_FORN.NM_FANT,
	PRC_FILIAL.NM_FANT,
	EST_PED_CP.CD_PED, 
	EST_PED_CP.DT_EMI,
	EST_PED_CP.DT_PREV_ENT DT_ENTR,
	5 , 
	'VINCULACAO PENDENCIA FILIAL ' + CONVERT(CHAR(3), EST_PED_CP.CD_FILIAL),
	EST_PED_CP.CD_PED AS CD_DOC_ORIC,
	0 AS CD_NT_MOV,
	STS_PED AS PARCIAL,
	EST_PED_CP.VLR_PED,
	GLB_MOV_OP.DEST_ORIG,
	EST_PED_CP.CD_USU,
	U.NM_USU
FROM    
	EST_PED_CP INNER JOIN PG_FORN ON
	EST_PED_CP.CD_EMP = PG_FORN.CD_EMP AND 
	EST_PED_CP.CD_FORN = PG_FORN.CD_FORN
	INNER JOIN EST_PED_CP_PENDENCIA PEND ON
	EST_PED_CP.CD_EMP = PEND.CD_EMP AND
	EST_PED_CP.CD_FILIAL = PEND.CD_FILIAL AND
	EST_PED_CP.CD_PED = PEND.CD_PED		 
	INNER JOIN PRC_FILIAL ON
	EST_PED_CP.CD_EMP = PRC_FILIAL.CD_EMP	AND
	EST_PED_CP.CD_FILIAL = PRC_FILIAL.CD_FILIAL
	INNER JOIN EST_PED_CP_VINCULADA ON
	EST_PED_CP.CD_EMP = EST_PED_CP_VINCULADA.CD_EMP AND
	EST_PED_CP.CD_FILIAL = EST_PED_CP_VINCULADA.CD_FILIAL AND
	EST_PED_CP.CD_PED = EST_PED_CP_VINCULADA.CD_PED
	INNER JOIN dbo.GLB_MOV_OP ON 
	EST_PED_CP.CD_NT_MOV = dbo.GLB_MOV_OP.CD_MOV_OP
	LEFT JOIN dbo.GLB_USU U ON 
	EST_PED_CP.CD_USU = U.CD_USU   
WHERE   
	EST_PED_CP.STS_PED <> 2
UNION ALL
SELECT     
	EST_PROD_TRANSF_PENDENCIA.CD_EMP, 
	EST_PROD_TRANSF_PENDENCIA.CD_FILIAL_ORIG, 
	EST_PROD_TRANSF_PENDENCIA.CD_FILIAL_DEST, 
	PRC_FILIAL_ORIG.NM_FANT AS NM_FANT_ORIG, 
	PRC_FILIAL_DEST.NM_FANT AS NM_FANT_DEST, 
	EST_PROD_TRANSF_PENDENCIA.CD_CTR, 
	EST_PROD_TRANSF.DT_TRANSF, 
	EST_PROD_TRANSF.DT_TRANSF DT_ENTR, 
	2 AS TP, 
	'RESSUPRIMENTO' AS DS_TP,
	EST_PROD_TRANSF_PENDENCIA.CD_CTR AS CD_DOC_ORIC,
	0 AS CD_NT_MOV,
	0 AS PARCIAL,
	0 AS VLR_TRANSF,
	0 AS DEST_ORIG,
	EST_PROD_TRANSF.CD_USU,
	U.NM_USU
FROM         
	EST_PROD_TRANSF INNER JOIN EST_PROD_TRANSF_PENDENCIA ON 
	EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_PENDENCIA.CD_EMP AND 
	EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_PENDENCIA.CD_FILIAL AND 
	EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_PENDENCIA.CD_CTR 
	INNER JOIN PRC_FILIAL AS PRC_FILIAL_ORIG ON 
	EST_PROD_TRANSF_PENDENCIA.CD_EMP = PRC_FILIAL_ORIG.CD_EMP AND 
	EST_PROD_TRANSF_PENDENCIA.CD_FILIAL_ORIG = PRC_FILIAL_ORIG.CD_FILIAL 
	INNER JOIN PRC_FILIAL AS PRC_FILIAL_DEST ON 
	EST_PROD_TRANSF_PENDENCIA.CD_EMP = PRC_FILIAL_DEST.CD_EMP AND 
	EST_PROD_TRANSF_PENDENCIA.CD_FILIAL_DEST = PRC_FILIAL_DEST.CD_FILIAL
	LEFT JOIN dbo.GLB_USU U ON 
	EST_PROD_TRANSF.CD_USU = U.CD_USU   
UNION ALL
SELECT     
	EST_PED_VD.CD_EMP,	
	EST_PED_VD.CD_FILIAL, 
	EST_PED_VD_PENDENCIA.CD_FILIAL_DEST, 
	PO.NM_FANT AS NM_FANT_ORIG, 
	PD.NM_FANT AS NM_FANT_DEST, 
    EST_PED_VD.CD_PED, 
	EST_PED_VD.DT_EMI_PED, 
	EST_PED_VD.DT_VALID DT_ENTR, 
	3 AS TIPO, 
	'PRE-FATURA' AS DS_TIPO_DOC,
	EST_PED_VD.CD_PED,
	0 AS CD_NT_MOV,
	0 AS PARCIAL,
	EST_PED_VD.VLR_TOT_PED,
	0 AS DEST_ORIG,
	EST_PED_VD.CD_USU,
	U.NM_USU
FROM         
	EST_PED_VD INNER JOIN EST_PED_VD_PENDENCIA ON 
	EST_PED_VD.CD_EMP = EST_PED_VD_PENDENCIA.CD_EMP AND 
    EST_PED_VD.CD_FILIAL = EST_PED_VD_PENDENCIA.CD_FILIAL AND 
	EST_PED_VD.CD_PED = EST_PED_VD_PENDENCIA.CD_PED
	INNER JOIN PRC_FILIAL PO ON
	EST_PED_VD.CD_EMP = PO.CD_EMP AND
	EST_PED_VD.CD_FILIAL = PO.CD_FILIAL 
	INNER JOIN PRC_FILIAL PD ON
	EST_PED_VD_PENDENCIA.CD_EMP = PD.CD_EMP AND
	EST_PED_VD_PENDENCIA.CD_FILIAL_DEST = PD.CD_FILIAL
	LEFT JOIN dbo.GLB_USU U ON 
	EST_PED_VD.CD_USU = U.CD_USU 
UNION ALL
SELECT     
	DISTINCT EST_PROD_REQ_TRANSF_LIB.CD_EMP,	
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL, 
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL_DEST, 
	PO.NM_FANT AS NM_FANT_ORIG, 
	PD.NM_FANT AS NM_FANT_DEST, 
    EST_PROD_REQ_TRANSF_LIB.CD_REQ, 
	EST_PROD_REQ_TRANSF_LIB.DT_CAD, 
	EST_PROD_REQ_TRANSF_LIB.DT_CAD DT_ENTR, 
	4 AS TIPO, 
	'REQUISICAO' AS DS_TIPO_DOC,
	EST_PROD_REQ_TRANSF_LIB.CD_REQ,
	0 AS CD_NT_MOV,
	0 AS PARCIAL,
	0 VLR_REQ,
	0 AS DEST_ORIG,
	EST_PROD_REQ_TRANSF_LIB.CD_USU,
	U.NM_USU
FROM         
	EST_PROD_REQ_TRANSF_LIB INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS ON 
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP AND 
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL AND 
    EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ 
	LEFT OUTER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP ON 
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP AND 
    EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_ORIG AND 
    EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_REQ AND 
    EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_PROD
	INNER JOIN PRC_FILIAL PO ON
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = PO.CD_EMP AND
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = PO.CD_FILIAL 
	INNER JOIN PRC_FILIAL PD ON
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = PD.CD_EMP AND
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL_DEST = PD.CD_FILIAL
	LEFT JOIN dbo.GLB_USU U ON 
	EST_PROD_REQ_TRANSF_LIB.CD_USU = U.CD_USU 
WHERE
	 EST_PROD_REQ_TRANSF_LIB.STS_CANCEL=0
	 AND EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_IMP IS NULL
UNION ALL
SELECT     
	DISTINCT
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_EMP, 
    CASE WHEN ISNULL(EST_PED_CP_PENDENCIA_IMPLANTACAO.BLQ_EST,0)=0 THEN
		EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FORN
	ELSE
		EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FILIAL
	END  AS CD_FORN, 
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FILIAL, 
    CASE WHEN ISNULL(EST_PED_CP_PENDENCIA_IMPLANTACAO.BLQ_EST,0)=0 THEN
		PG_FORN.NM_FANT	
	ELSE
		PRC_FILIAL.NM_FANT
	END  AS NM_FANT, 
    PRC_FILIAL.NM_FANT AS NM_FANT_FILIAL, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_CTR, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.DT_CAD, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.DT_CAD AS DT_ENTR, 
    7 AS TIPO_DOC, 
    CASE WHEN ISNULL(EST_PED_CP_PENDENCIA_IMPLANTACAO.BLQ_EST,0)=0 THEN
		'PENDENCIA ENTRADA IMPLANTACAO'
	ELSE
		'BLOQUEIO DE ESTOQUE DE PRODUTOS - ENTRADA'
	END  AS DS_TIPO_DOC, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO_CPL.CD_CTR AS CD_DOC_ORIC, 
    0 AS CD_NT_MOV, 
    0 AS PARCIAL, 
    0 AS VLR_PED,
	0 AS DEST_ORIG,
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_USU ,
	U.NM_USU
FROM         
	EST_PED_CP_PENDENCIA_IMPLANTACAO_CPL INNER JOIN EST_PED_CP_PENDENCIA_IMPLANTACAO ON 
	EST_PED_CP_PENDENCIA_IMPLANTACAO_CPL.CD_CTR = EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_CTR 
	INNER JOIN PG_FORN ON 
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_EMP = PG_FORN.CD_EMP AND 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FORN = PG_FORN.CD_FORN 
    INNER JOIN PRC_FILIAL ON 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_EMP = PRC_FILIAL.CD_EMP AND 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    LEFT JOIN dbo.GLB_USU U ON 
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_USU = U.CD_USU 
UNION ALL
SELECT     
	DISTINCT
	V_EST_NF_ENT_CAB.CD_EMP, 
	V_EST_NF_ENT_CAB.CD_FILIAL, 
	V_EST_NF_ENT_CAB.CD_FILIAL, 
    V_EST_NF_ENT_CAB.NM_ORIG_FANT, 
    V_EST_NF_ENT_CAB.NM_FANT AS NM_FANT_FILIAL, 
    V_EST_NF_ENT_CAB.NR_NF, 
    EST_NF_ENT_CROSS_DOCKING_PENDENTE.DT_CAD, 
    V_EST_NF_ENT_CAB.DT_ENT AS DT_ENTR, 
    8 AS TIPO_DOC, 
    'CROSS-DOCKING/BLOQUEIO DE ESTOQUE' AS DS_TIPO_DOC, 
    V_EST_NF_ENT_CAB.CD_NF AS CD_DOC_ORIC, 
    0 AS CD_NT_MOV, 
    0 AS PARCIAL, 
    V_EST_NF_ENT_CAB.VLR_NF  AS VLR_PED,
    V_EST_NF_ENT_CAB.DEST_ORIG,
    EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_USU,
    U.NM_USU
FROM         
	V_EST_NF_ENT_CAB INNER JOIN EST_NF_ENT_CROSS_DOCKING_PENDENTE ON 
	V_EST_NF_ENT_CAB.CD_EMP = EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_EMP AND 
	V_EST_NF_ENT_CAB.CD_FILIAL = EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_FILIAL AND 
	V_EST_NF_ENT_CAB.CD_NF = EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_NF    
	LEFT JOIN dbo.GLB_USU U ON 
	EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_USU = U.CD_USU

UNION ALL

	SELECT DISTINCT
		D.CD_EMP, 
		D.CD_FILIAL, 
		CASE WHEN  O.DEST_ORIG=2 THEN 
			I.CD_FORN
		ELSE 
			0 
		END AS CD_FILIAL_DEST,
		F.NM_FANT,
		'DEVOLUCAO DE COMPRAS PENDENTE DE EMISSAO' AS NM_FANT_FILIAL,
		I.NR_NF,
		I.DT_ENT,
		D.DT_DEVOLUCAO,
		9 AS TP,
		'DEVOLUCAO DE COMPRAS PENDENTE DE EMISSAO' AS DS_TIPO_DOC,
		I.CD_NF,
		0 AS CD_NT_MOV,
		0 AS PARCIAL,
		I.VLR_NF,
		O.DEST_ORIG,
		I.CD_USU,
		GLB_USU.NM_USU		
	FROM 
		EST_NF_ENT_IT_DEVOLUCAO D
		INNER JOIN V_EST_NF_ENT I ON
			D.CD_EMP = I.CD_EMP AND 
			D.CD_FILIAL = I.CD_FILIAL AND 
			D.CD_NF = I.CD_NF
		INNER JOIN GLB_MOV_OP O ON
			I.CD_MOV_OP = O.CD_MOV_OP
		INNER JOIN GLB_USU ON
			I.CD_USU = GLB_USU.CD_USU
		INNER JOIN PRC_FILIAL F ON
			D.CD_EMP = F.CD_EMP
			AND D.CD_FILIAL = F.CD_FILIAL
	WHERE
		D.QTDE_PROD - D.QTDE_PROD_DEVO_GERADA > 0
		AND D.CD_EMP = 1
UNION ALL
SELECT 
	DISTINCT 
	e.CD_EMP, 
	E.CD_FILIAL, 
	E.CD_FILIAL,
	F.NM_FANT,
	'DEMANDA DE COMPRAS EM ABERTO' AS NM_FANT_FILIAL,
	E.CD_PED_SOL AS NR_NF,
	E.DT_PED,
	E.DT_PED,
	10 AS TP,
	'DEMANDA DE COMPRAS EM ABERTO' AS DS_TIPO_DOC,
	E.CD_PED_SOL,
	0 AS CD_NT_MOV,
	0 AS PARCIAL,
	0 AS VLR_NF,
	0 AS DEST_ORIG,
	E.CD_USU,
	GLB_USU.NM_USU	
FROM 
	V_EST_PED_ELTR_DEMANDA_EM_ABERTO E 
INNER JOIN GLB_USU ON
	E.CD_USU = GLB_USU.CD_USU
INNER JOIN PRC_FILIAL F ON
	E.CD_EMP = F.CD_EMP
	AND E.CD_FILIAL = F.CD_FILIAL
UNION ALL
SELECT     
	DISTINCT
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_EMP, 
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FILIAL, 
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FILIAL, 
    PG_FORN.NM_FANT, 
    PRC_FILIAL.NM_FANT AS NM_FANT_FILIAL, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_CTR, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.DT_CAD, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.DT_CAD AS DT_ENTR, 
    11 AS TIPO_DOC, 
	'BLOQUEIO DE ESTOQUE DE PRODUTOS - SAIDA' AS DS_TIPO_DOC, 
    EST_PED_CP_PENDENCIA_IMPLANTACAO_CPL.CD_CTR AS CD_DOC_ORIC, 
    0 AS CD_NT_MOV, 
    0 AS PARCIAL, 
    0 AS VLR_PED,
	0 AS DEST_ORIG,
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_USU ,
	U.NM_USU
FROM         
	EST_PED_CP_PENDENCIA_IMPLANTACAO_CPL INNER JOIN EST_PED_CP_PENDENCIA_IMPLANTACAO ON 
	EST_PED_CP_PENDENCIA_IMPLANTACAO_CPL.CD_CTR = EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_CTR 
	INNER JOIN PG_FORN ON 
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_EMP = PG_FORN.CD_EMP AND 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FORN = PG_FORN.CD_FORN 
    INNER JOIN PRC_FILIAL ON 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_EMP = PRC_FILIAL.CD_EMP AND 
    EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    LEFT JOIN dbo.GLB_USU U ON 
	EST_PED_CP_PENDENCIA_IMPLANTACAO.CD_USU = U.CD_USU
WHERE
	EST_PED_CP_PENDENCIA_IMPLANTACAO.BLQ_EST=1
UNION ALL
SELECT
	DISTINCT 
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_EMP,
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_FILIAL,
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_FILIAL AS CD_ORIG,
	PRC_FILIAL.NM_FANT,
	'PBM - PENDENCIA DE ENTRADA POR VENDA' AS NM_FANT_FILIAL,
	0 AS NR_NF,
	CONVERT(CHAR(10),GETDATE(),112) AS DT_EMI_NF,
	CONVERT(CHAR(10),GETDATE(),112) AS DT_EMI_NF,
	12 AS TP,
	'PBM - PENDENCIA DE ENTRADA POR VENDA',
	0 AS CD_PED_SOL,
	0 AS CD_NT_MOV,
	0 AS PARCIAL,
	0 AS VLR_NF,
	0 AS DEST_ORIG,
	0 AS CD_USU,
	'' AS NM_USU	
FROM
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD INNER JOIN PRC_FILIAL ON
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_EMP = PRC_FILIAL.CD_EMP AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
WHERE
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.QT_SALDO  > 0